DELIMITER $$
DROP PROCEDURE IF EXISTS V20220609172659__Update_ApproveAdmissionDydtDataLineItem $$
CREATE PROCEDURE V20220609172659__Update_ApproveAdmissionDydtDataLineItem()
BEGIN

IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='APPROVE_ADMISSION_DYNAMIC_DOCUMENT_INFO' order by id desc limit 1)) THEN 
SET @dydtdatalinitemId=(select MAX(id) from dydt_data_line_item where dataSourceCode='APPROVE_ADMISSION_DYNAMIC_DOCUMENT_INFO');

update dydt_data_line_item set sqlSelectQueryDef="SELECT
   T4.code AS APPLICATION_CODE,
  T6.displayName AS ACADEMY_NAME_LOCATION,
  T5.printName AS applicant_printname,
  T7.programNameToBePrint AS program_print_name,
   T5.firstName AS FIRST_NAME, 
  T5.firstNameOtherLanguage AS FIRST_NAME_OTHER_LANGUAGE,
  T5.middleName AS MIDDLE_NAME,
  T5.middleNameOtherLanguage AS MIDDLE_NAME_OTHER_LANGUAGE,
  T5.lastName AS LAST_NAME,
  T5.lastNameOtherLanguage AS LAST_NAME_OTHER_LANGUAGE,
  T7.programCode AS PROGRAM_CODE,
    T7.programName AS PROGRAM_NAME,
    T7.programNameLanguageOne AS PROGRAM_NAME_OTHER_LANGUAGE,
	T8.addressText AS APPLICANT_ADDRESS, 
    T8.addressTextOtherLanguage AS APPLICANT_ADDRESS_OTHER_LANGUAGE,
    T9.cityName AS APPLICANT_CITY,
    T8.pincode AS APPLICANT_POSTAL_CODE,
    T10.countryName AS COUNTRY_NAME,
	CURRENT_DATE() as DOCUMENT_PRINT_DATE,
    (CASE
         WHEN
             T6.logoUrl IS NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl,
                     '/',
                     'emailer/images/logo_default_image.png')
         WHEN
             T6.logoUrl IS NULL
                 AND org.orgUrl IS NULL
         THEN
             'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
         ELSE CONCAT(org.orgUrl, '/', T6.logoUrl)
     END) AS ACADEMY_LOCATION_LOGO,
     bhd.totalAmount AS ADMISSION_COMMITMENT_FEES
 	FROM `application_admission_detail` T1
 	INNER JOIN `application_program` T2 ON T1.applicationProgramId = T2.id
         LEFT JOIN `academy_location` T6 ON T2.academyLocationId = T6.id
         LEFT JOIN `programs` T7 ON T2.programId = T7.id
 	LEFT JOIN `prog_batch_seat_config` T3 ON T3.id=T2.`progBatchSeatConfigId`
 	LEFT JOIN `application` T4 ON T2.applicationId=T4.`id`
 	LEFT JOIN `applicant_person` T5 ON T4.applicantPersonId=T5.id
	LEFT JOIN (select add1.* from applicant_address add1 left join address_type addty1
on (add1.addressTypeId=addty1.id and addty1.addressTypeName='Current' and addty1.addressCategory='PERSON'))
T8 on (T8.`applicantPersonId`=T5.`id`)
       LEFT JOIN `city` T9 ON T9.`id`=T8.`cityId`
     LEFT JOIN `country` T10 ON T10.`id`=T8.countryId
     LEFT JOIN  (select bh.* from bill_header bh
left join bill_fee_plan_rule_stage bfprs on bh.id=bfprs.billId
  left join fee_stage_head_config fshc on fshc.id=bfprs.feeStageHeadConfigId
  left join fee_plan_rule_stage fprs on fprs.id=fshc.feePlanRuleStageId
   inner join fee_stage_master fsm on fsm.id=fprs.stageId
   AND  fsm.stageName='Admission commitment' ) bhd on (T4.id=bhd.applicantId)
       LEFT JOIN
     organizations org ON org.id = (SELECT 
             MAX(id)
         FROM
             organizations) ",
   resultColumnsDef="APPLICATION_CODE,ACADEMY_NAME_LOCATION,applicant_printname,program_print_name,FIRST_NAME,FIRST_NAME_OTHER_LANGUAGE,MIDDLE_NAME,MIDDLE_NAME_OTHER_LANGUAGE,LAST_NAME,LAST_NAME_OTHER_LANGUAGE,PROGRAM_CODE,PROGRAM_NAME,PROGRAM_NAME_OTHER_LANGUAGE,APPLICANT_ADDRESS,APPLICANT_ADDRESS_OTHER_LANGUAGE,APPLICANT_CITY,APPLICANT_POSTAL_CODE,COUNTRY_NAME,DOCUMENT_PRINT_DATE,ACADEMY_LOCATION_LOGO,ADMISSION_COMMITMENT_FEES" where dataSourceCode="APPROVE_ADMISSION_DYNAMIC_DOCUMENT_INFO" and id=@dydtdatalinitemId;

   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICATION_CODE', 'Application Code',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ACADEMY_NAME_LOCATION', 'Academy Name Location',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('applicant_printname', 'Applicant Print Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('program_print_name', 'Program Print Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('FIRST_NAME', 'Applicant First Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('FIRST_NAME_OTHER_LANGUAGE', 'Applicant First Name - other language',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MIDDLE_NAME', 'Applicant Middle Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MIDDLE_NAME_OTHER_LANGUAGE', 'Applicant Middle Name - other language',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('LAST_NAME', 'Applicant Surname',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('LAST_NAME_OTHER_LANGUAGE', 'Applicant last name/surname -other language',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PROGRAM_CODE', 'Program Code',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PROGRAM_NAME', 'Program Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PROGRAM_NAME_OTHER_LANGUAGE', 'Program Name - other language',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_ADDRESS', 'Applicant Address',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_ADDRESS_OTHER_LANGUAGE', 'Applicant Address - other language',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_CITY', 'Applicant City',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_POSTAL_CODE', 'Applicant Postal Code ',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COUNTRY_NAME', "Applicant's Country",@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('DOCUMENT_PRINT_DATE', 'Date',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ACADEMY_LOCATION_LOGO', 'Academy location Logo',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ADMISSION_COMMITMENT_FEES', 'Admission Commitment Fees',@dydtdatalinitemId);

END IF; 

END $$
CALL V20220609172659__Update_ApproveAdmissionDydtDataLineItem () $$
DROP PROCEDURE IF EXISTS V20220609172659__Update_ApproveAdmissionDydtDataLineItem $$
DELIMITER ;